# Simulation

u=runif(10000)
hist(u,prob=TRUE)
curve(dunif,0,1,add=TRUE,col="blue")

lambda=2
x=-log(1-u)/lambda
hist(x,prob=TRUE,nclass=30)
curve(dexp(x,2),0,5,add=TRUE,col="blue")

# Accept-reject algorithm

p=function(x) {dexp(x,2)/pexp(2,2)}
curve(p,0,2,col="blue")
curve(dunif(x,0,2),add=TRUE,col="red")

N=1000
x=rep(0,N)
k=4/pexp(2,2)

nsimu=0
for (i in 1:N)
{
bool=TRUE
while(bool)
{
nsimu=nsimu+1
y=runif(1,0,2)
M=p(y)/(k*dunif(y,0,2))
if (runif(1)<=M) bool=FALSE
}
x[i]=y
}

hist(x,prob=TRUE)
curve(p,0,2,add=TRUE,col="blue")

# Hastings-Metropolis algorithm

target=function(x){dnorm(x)}

Niter=1000
x=rep(0,Niter)
x[1]=rnorm(1)
sigma=2

for (i in 2:Niter)
{
xtilde=rnorm(1,x[i-1],sigma)
rho=target(xtilde)/target(x[i-1])
if (runif(1)<=rho) x[i]=xtilde else x[i]=x[i-1]
}

plot(x,type="l",xlab="Iterations")
plot(acf(x))
hist(x,main="Histogram",prob=TRUE)
curve(dnorm,add=TRUE,col="blue")

# Gibbs sampler

n=10
alpha=1
beta=2
gibbs=function(niter)
{
x=matrix(0,niter+1,2)
x[1,1]=5
x[1,2]=rbeta(1,x[1,1]+alpha,n-x[1,1]+beta)
for (t in 2:(niter+1))
{
x[t,1]=rbinom(1,n,x[t-1,2])
x[t,2]=rbeta(1,x[t,1]+alpha,n-x[t,1]+beta)
}
x
}
x=gibbs(10000)
plot(x[,2],type="l",xlab="Iterations",ylab="p")
plot(acf(x[,2]))
hist(x[,2],prob=TRUE)
curve(dbeta(x,alpha,beta),0,1,col="blue",add=TRUE)

# JAGS and rjags

library(rjags)

# A first beta-binomial example

data1=list("y"=7,"n"=50,"alpha"=0.5,"beta"=0.5)
inits1=list("p"=0.1)
model1=jags.model("model1",data1,inits1,4)
update(model1,10000)
res1=coda.samples(model1,"p",1000000,10)
summary(res1)

par(mfrow=c(2,2))
for (i in 1:4) 
{
hist(res1[[i]],prob=TRUE,col="azure3",xlab="",main="")
curve(dbeta(x,7.5,43.5),0,0.4,add=TRUE,col="red")
}

# Inference for a two-stage capture model

data2=list("n1"=22,"m2"=11,"c2"=49)
model2=jags.model("model2",data2)
update(model2,1000)
res2=coda.samples(model2,c("N","p"),10000,10)

summary(res2)
plot(res2)

# Basic Linear Regression

n=100
x=1:n
epsilon=rnorm(n,0,10)
y=x+epsilon

data3=list("y"=y,"x"=x,"n"=n)
model3=jags.model("model3",data3,n.chains=2,n.adapt=100)
update(model3,1000)
res3=coda.samples(model3,c("a","b","tau"),10000,10)


# library bayess assocaited to the Bayesian essentials with R

library(bayess)
demo(Chapter.3)
model.reg=BayesReg(y,X)
ModChoBayesReg(y,X)

